// Form1.h
//
// This file declares a Form-derived class that is also
// a remote TPI.NET client.
/////////////////////////////////////////////////////////////

#pragma once

namespace CPPRemoteClientSample {

__gc class Form1 :
    public System::Windows::Forms::Form
{
    // Members supporting the UI controls.
	void InitializeComponent();
    System::Windows::Forms::Label* m_versionLabel;
    System::Windows::Forms::Button* m_runButton;
    System::Windows::Forms::Label* m_label1;
    System::Windows::Forms::Label* m_eventLabel;
    System::ComponentModel::Container* m_components;

    // A reference to the top of the TPI.NET object hierarchy
	// in the remote TLA application
	Tektronix::LogicAnalyzer::TpiNet::ITlaSystem* m_system;
    
	// Event shims that are required to subscribe to
	// events raised by the remote TLA application.
	Tektronix::LogicAnalyzer::TpiNet::EventRemoter* m_runStartRemoter;
    Tektronix::LogicAnalyzer::TpiNet::EventRemoter* m_runCompleteRemoter;
    
    // Event Handlers for events raised by the TLA application
	void OnRunStarted (System::Object*, System::EventArgs* args);
    void OnRunCompleted (System::Object*, System::EventArgs* args);
    
	// Event Handler for events raised by the Form object.
	void OnRunButton (System::Object*, System::EventArgs* args);
    void OnFormClosed (System::Object*, System::EventArgs* args);

public:
    Form1(void);
    
};

} // End namespace